/*:
 * @plugindesc Change MP display to show a specific game variable value in battle.
 * @param VariableID
 * @type number
 * @min 1
 * @desc The ID of the game variable to display instead of MP.
 * @default 26
 * @help This plugin changes the MP display in battle to show the value of a specified variable.
 */

(function() {
    var parameters = PluginManager.parameters('CustomMPDisplay');
    var variableID = Number(parameters['VariableID'] || 26);

    Window_Base.prototype.drawActorMp = function(actor, x, y, width) {
        width = width || 186;
        var value = $gameVariables.value(variableID);
        var maxValue = actor.mmp;
        var color1 = this.mpGaugeColor1();
        var color2 = this.mpGaugeColor2();
        this.drawGauge(x, y, width, value / maxValue, color1, color2);
        this.changeTextColor(this.systemColor());
        this.drawText(TextManager.mpA, x, y, 44);
        this.drawCurrentAndMax(value, maxValue, x, y, width,
                               this.mpColor(actor), this.normalColor());
    };
})();
